/*****************************************************************************
 * Project: SCT Application Example for LPC15xx
 *
 * Implements a start stop event example for the SCT0 
 *
 * For this application the following interface pins are used:
 * -------------------------------------------------------------------------
 * Signal    Port               Signal      
 * -------------------------------------------------------------------------
 * SCT0_OUT0   P0_6   pin 16      COUNTER_L_RUN
 * SCT0_OUT1   P0_7   pin 17      COUNTER_H_RUN
 * SCT0_OUT2   P0_8   pin 19      STATE_1
 * SCT0_OUT3   P0_0   pin 2       STATE_2
 * ------------------------------------------------------------------------*/
#include "start_stop.h"

int main (void) 
{
    LPC_SWM->PINASSIGN7 &= 0x080706FF;             // SCT0_OUT0 at P0_6, SCT0_OUT1 at P0_7, SCT0_OUT2 at P0_8
    LPC_SWM->PINENABLE1 &= ~(1 << 5);              // SCT0_OUT3 at P0_0

    start_stop_init();
    
    while (1) 
    {
    }
}
